/*---------------------------------------------------------------------------*\

    FILE....: COMM.H
    TYPE....: C Function Header File
    AUTHOR..: David Rowe
    DATE....: 2/10/97

    Functions used for PC to DSP communications, which includes passing
    messages to and from the DSP, and transfering information to and from
    FIFOs in the DSP.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#ifndef __COMM__
#define __COMM__

#include "contypes.h"
#include "vpbreg.h"
#include "messages.h"

/*-------------------------------------------------------------------------*\

			       DEFINES

\*-------------------------------------------------------------------------*/

// return codes for message functions below 

#define	OK				0
#define	COMM_MAX_MESS	128	// maximum message length from PC	  
#define	COMM_FULL		1	// write failed as DSP message queue full 
#define	COMM_EMPTY		2	// read failed as no messages		  

/*-------------------------------------------------------------------------*\

			    FUNCTION HEADERS

\*-------------------------------------------------------------------------*/

class CommData;

class Comm {
	CommData	*d;
public:
	Comm();
	~Comm();
	int PutMessageVPB(USHORT board, word *mess);
	int GetMessageVPB(USHORT board, word *mess);
	void WaitForMessageVPB(USHORT board, word *mess, USHORT mtype, USHORT wait);
	VPBREG *vpbreg(USHORT board);
	USHORT Comm::numboards();
	Hip *hip(USHORT board);
	void CheckForAssert(USHORT board);
};

#endif	/* #ifndef __COMM__	*/

